import pandas as pd  
import pickle
  
# Load the dataset  
credit_customers = pd.read_csv("credit_customers.csv")

# Calculate the 75th percentile for credit_amount and duration  
credit_amount_75th = credit_customers['credit_amount'].quantile(0.75)  
duration_75th = credit_customers['duration'].quantile(0.75)  
  
# Filter the dataset based on the calculated values  
high_credit_long_duration = credit_customers[(credit_customers['credit_amount'] > credit_amount_75th) & (credit_customers['duration'] > duration_75th)]  
  
# Extract the required information (client IDs, credit amounts, and loan durations)  
result = high_credit_long_duration[['credit_amount', 'duration']]  
  
# Convert the result to a list of tuples  
result_list = list(result.itertuples(index=True, name=None))  
  
print(result_list) 
pickle.dump(result_list,open("./ref_result/result_list_1.pkl","wb"))